/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ClassAlias;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.ExceptionUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BeanProxy
extends AbstractProxy {
    static final long serialVersionUID = 7365078101695257715L;
    private static final int FAILED_PROPERTY_READ_ERROR = 10021;
    private static final int FAILED_PROPERTY_WRITE_ERROR = 10022;
    private static final int NON_READABLE_PROPERTY_ERROR = 10023;
    private static final int NON_WRITABLE_PROPERTY_ERROR = 10024;
    private static final int UNKNOWN_PROPERTY_ERROR = 10025;
    protected static final Map propertyNamesCache = new IdentityHashMap();
    protected static final Map beanPropertyCache = new IdentityHashMap();
    protected static final Map propertyDescriptorCache = new IdentityHashMap();
    protected boolean cacheProperties = true;
    protected boolean cachePropertiesDescriptors = true;
    protected Class stopClass = Object.class;
    protected static final Map ignoreProperties = new HashMap();

    public BeanProxy() {
        this(null);
    }

    public BeanProxy(Object defaultInstance) {
        super(defaultInstance);
        if (defaultInstance != null) {
            this.alias = this.getClassName(defaultInstance);
        }
    }

    public String getAlias(Object instance) {
        return this.getClassName(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPropertyNames(Object instance) {
        if (instance == null) {
            return null;
        }
        Class<?> c = instance.getClass();
        List<String> propertyNames = null;
        if (this.descriptor == null) {
            propertyNames = (ArrayList<String>)propertyNamesCache.get(c);
        }
        if (propertyNames != null) {
            return propertyNames;
        }
        Map properties = this.getBeanProperties(instance);
        propertyNames = new ArrayList<String>(properties.size());
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            propertyNames.add(it.next().toString());
        }
        if (this.cacheProperties && this.descriptor == null) {
            Map map = propertyNamesCache;
            synchronized (map) {
                List propertyNames2 = (List)propertyNamesCache.get(c);
                if (propertyNames2 == null) {
                    propertyNamesCache.put(c, propertyNames);
                } else {
                    propertyNames = propertyNames2;
                }
            }
        }
        return propertyNames;
    }

    public Class getType(Object instance, String propertyName) {
        if (instance == null || propertyName == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(instance, propertyName);
        return bp == null ? null : bp.getType();
    }

    public Object getValue(Object instance, String propertyName) {
        if (instance == null || propertyName == null) {
            return null;
        }
        BeanProperty bp = this.getBeanProperty(instance, propertyName);
        if (bp != null) {
            return this.getBeanValue(instance, bp);
        }
        SerializationContext context = this.getSerializationContext();
        if (!this.ignorePropertyErrors(context)) {
            MessageException ex = new MessageException();
            ex.setMessage(10025, new Object[]{propertyName, this.getAlias(instance)});
            throw ex;
        }
        return null;
    }

    protected final Object getBeanValue(Object instance, BeanProperty bp) {
        String propertyName = bp.getName();
        if (bp.isRead()) {
            try {
                SerializationDescriptor subDescriptor;
                Object value = bp.get(instance);
                if (value != null && this.descriptor != null && (subDescriptor = (SerializationDescriptor)this.descriptor.get(propertyName)) != null) {
                    PropertyProxy subProxy = PropertyProxyRegistry.getProxyAndRegister(value);
                    subProxy = (PropertyProxy)subProxy.clone();
                    subProxy.setDescriptor(subDescriptor);
                    subProxy.setDefaultInstance(value);
                    value = subProxy;
                }
                return value;
            }
            catch (Exception e) {
                SerializationContext context = this.getSerializationContext();
                if (Log.isWarn() && this.logPropertyErrors(context)) {
                    Logger log = Log.getLogger((String)"Endpoint.Type");
                    log.warn("Failed to get property {0} on type {1}.", new Object[]{propertyName, this.getAlias(instance)}, (Throwable)e);
                }
                if (!this.ignorePropertyErrors(context)) {
                    MessageException ex = new MessageException();
                    ex.setMessage(10021, new Object[]{propertyName, this.getAlias(instance)});
                    ex.setRootCause(e);
                    throw ex;
                }
            }
        } else {
            SerializationContext context = this.getSerializationContext();
            if (!this.ignorePropertyErrors(context)) {
                MessageException ex = new MessageException();
                ex.setMessage(10023, new Object[]{propertyName, this.getAlias(instance)});
                throw ex;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(Object instance, String propertyName, Object value) {
        BeanProperty bp = this.getBeanProperty(instance, propertyName);
        if (bp != null) {
            if (bp.isWrite()) {
                try {
                    Class desiredPropClass = bp.getType();
                    TypeMarshaller marshaller = TypeMarshallingContext.getTypeMarshaller();
                    value = marshaller.convert(value, desiredPropClass);
                    ClassUtil.validateAssignment(instance, propertyName, value);
                    bp.set(instance, value);
                    return;
                }
                catch (Exception e) {
                    SerializationContext context = this.getSerializationContext();
                    if (Log.isWarn() && this.logPropertyErrors(context)) {
                        Logger log = Log.getLogger((String)"Endpoint.Type");
                        log.warn("Failed to set property {0} on type {1}.", new Object[]{propertyName, this.getAlias(instance)}, (Throwable)e);
                    }
                    if (this.ignorePropertyErrors(context)) return;
                    MessageException ex = new MessageException();
                    ex.setMessage(10022, new Object[]{propertyName, this.getAlias(instance)});
                    ex.setRootCause(e);
                    throw ex;
                }
            }
            SerializationContext context = this.getSerializationContext();
            if (Log.isWarn() && this.logPropertyErrors(context)) {
                Logger log = Log.getLogger((String)"Endpoint.Type");
                log.warn("Property {0} not writable on class {1}", new Object[]{propertyName, this.getAlias(instance)});
            }
            if (this.ignorePropertyErrors(context)) return;
            MessageException ex = new MessageException();
            ex.setMessage(10024, new Object[]{propertyName, this.getAlias(instance)});
            throw ex;
        }
        SerializationContext context = this.getSerializationContext();
        if (Log.isWarn() && this.logPropertyErrors(context)) {
            Logger log = Log.getLogger((String)"Endpoint.Type");
            log.warn("Ignoring set property {0} for type {1} as a setter could not be found.", new Object[]{propertyName, this.getAlias(instance)});
        }
        if (this.ignorePropertyErrors(context)) return;
        MessageException ex = new MessageException();
        ex.setMessage(10025, new Object[]{propertyName, this.getAlias(instance)});
        throw ex;
    }

    protected boolean ignorePropertyErrors(SerializationContext context) {
        return context.ignorePropertyErrors;
    }

    protected boolean logPropertyErrors(SerializationContext context) {
        return context.logPropertyErrors;
    }

    protected String getClassName(Object instance) {
        String className;
        if (instance instanceof ASObject) {
            className = ((ASObject)instance).getType();
        } else if (instance instanceof ClassAlias) {
            className = ((ClassAlias)instance).getAlias();
        } else {
            className = instance.getClass().getName();
            ClassAliasRegistry registry = ClassAliasRegistry.getRegistry();
            String aliasedClass = registry.getClassName(className);
            className = aliasedClass == null ? className : aliasedClass;
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getBeanProperties(Object instance) {
        Field[] fields;
        Map<String, BeanProperty> props;
        Class<?> c = instance.getClass();
        if (this.descriptor == null && (props = (Map)beanPropertyCache.get(c)) != null) {
            return props;
        }
        props = new HashMap();
        PropertyDescriptor[] pds = this.getPropertyDescriptors(c);
        if (pds == null) {
            return null;
        }
        List excludes = null;
        if (this.descriptor != null && (excludes = this.descriptor.getExcludesForInstance(instance)) == null) {
            excludes = this.descriptor.getExcludes();
        }
        for (PropertyDescriptor pd : pds) {
            Class<?> type;
            String propertyName = pd.getName();
            Method readMethod = pd.getReadMethod();
            Method writeMethod = pd.getWriteMethod();
            if (readMethod != null && BeanProxy.isPublicAccessor(readMethod.getModifiers()) && !this.includeReadOnly && writeMethod == null || excludes != null && excludes.contains(propertyName) || BeanProxy.isPropertyIgnored(c, propertyName) || this.includeReadOnly && writeMethod == null && "class".equals(propertyName) || (type = pd.getPropertyType()) != null && ClassLoader.class.isAssignableFrom(type)) continue;
            props.put(propertyName, new BeanProperty(propertyName, pd.getPropertyType(), readMethod, writeMethod, null));
        }
        for (Field field : fields = instance.getClass().getFields()) {
            String propertyName = field.getName();
            int modifiers = field.getModifiers();
            if (!BeanProxy.isPublicField(modifiers) || props.containsKey(propertyName) || excludes != null && excludes.contains(propertyName) || BeanProxy.isPropertyIgnored(c, propertyName)) continue;
            props.put(propertyName, new BeanProperty(propertyName, field.getType(), null, null, field));
        }
        if (this.descriptor == null && this.cacheProperties) {
            Map map = beanPropertyCache;
            synchronized (map) {
                Map props2 = (Map)beanPropertyCache.get(c);
                if (props2 == null) {
                    beanPropertyCache.put(c, props);
                } else {
                    props = props2;
                }
            }
        }
        return props;
    }

    public boolean isWriteOnly(Object instance, String propertyName) {
        if (instance == null || propertyName == null) {
            return false;
        }
        BeanProperty bp = this.getBeanProperty(instance, propertyName);
        return bp != null && bp.isWrite() && !bp.isRead();
    }

    protected final BeanProperty getBeanProperty(Object instance, String propertyName) {
        Class<?> c = instance.getClass();
        if (this.descriptor == null && this.cacheProperties) {
            Map props = this.getBeanProperties(instance);
            return props == null ? null : (BeanProperty)props.get(propertyName);
        }
        PropertyDescriptorCacheEntry pce = this.getPropertyDescriptorCacheEntry(c);
        if (pce == null) {
            return null;
        }
        Object pType = pce.propertiesByName.get(propertyName);
        if (pType == null) {
            return null;
        }
        List excludes = null;
        if (this.descriptor != null && (excludes = this.descriptor.getExcludesForInstance(instance)) == null) {
            excludes = this.descriptor.getExcludes();
        }
        if (pType instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)pType;
            Method readMethod = pd.getReadMethod();
            Method writeMethod = pd.getWriteMethod();
            if (readMethod != null && BeanProxy.isPublicAccessor(readMethod.getModifiers()) && !this.includeReadOnly && writeMethod == null) {
                return null;
            }
            if (excludes != null && excludes.contains(propertyName) || BeanProxy.isPropertyIgnored(c, propertyName)) {
                return null;
            }
            return new BeanProperty(propertyName, pd.getPropertyType(), readMethod, writeMethod, null);
        }
        if (pType instanceof Field) {
            Field field = (Field)pType;
            String pName = field.getName();
            int modifiers = field.getModifiers();
            if (BeanProxy.isPublicField(modifiers) && pName.equals(propertyName)) {
                return excludes != null && excludes.contains(propertyName) || BeanProxy.isPropertyIgnored(c, propertyName) ? null : new BeanProperty(propertyName, field.getType(), null, null, field);
            }
        }
        return null;
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class c) {
        PropertyDescriptorCacheEntry pce = this.getPropertyDescriptorCacheEntry(c);
        return pce == null ? null : pce.propertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyDescriptorCacheEntry getPropertyDescriptorCacheEntry(Class c) {
        PropertyDescriptorCacheEntry pce;
        block8: {
            pce = (PropertyDescriptorCacheEntry)propertyDescriptorCache.get(c);
            try {
                if (pce != null) break block8;
                BeanInfo beanInfo = Introspector.getBeanInfo(c, this.stopClass);
                pce = new PropertyDescriptorCacheEntry();
                pce.propertyDescriptors = beanInfo.getPropertyDescriptors();
                pce.propertiesByName = this.createPropertiesByNameMap(pce.propertyDescriptors, c.getFields());
                if (!this.cachePropertiesDescriptors) break block8;
                Map map = propertyDescriptorCache;
                synchronized (map) {
                    PropertyDescriptorCacheEntry pce2 = (PropertyDescriptorCacheEntry)propertyDescriptorCache.get(c);
                    if (pce2 == null) {
                        propertyDescriptorCache.put(c, pce);
                    } else {
                        pce = pce2;
                    }
                }
            }
            catch (IntrospectionException ex) {
                if (Log.isError()) {
                    Logger log = Log.getLogger((String)"Endpoint.Type");
                    log.error("Failed to introspect object of type: " + c + " error: " + ExceptionUtil.toString((Throwable)ex));
                }
                pce = new PropertyDescriptorCacheEntry();
                pce.propertyDescriptors = new PropertyDescriptor[0];
                pce.propertiesByName = new TreeMap();
            }
        }
        return pce;
    }

    private Map createPropertiesByNameMap(PropertyDescriptor[] pds, Field[] fields) {
        int i;
        HashMap<String, Object> m = new HashMap<String, Object>(pds.length);
        for (i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || !BeanProxy.isPublicAccessor(readMethod.getModifiers()) || !this.includeReadOnly && pd.getWriteMethod() == null) continue;
            m.put(pd.getName(), pd);
        }
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!BeanProxy.isPublicField(field.getModifiers()) || m.containsKey(field.getName())) continue;
            m.put(field.getName(), field);
        }
        return m;
    }

    public static boolean isPropertyIgnored(Class c, String propertyName) {
        boolean result = false;
        Set propertyOwners = (Set)ignoreProperties.get(propertyName);
        if (propertyOwners != null) {
            while (c != null) {
                if (propertyOwners.contains(c)) {
                    result = true;
                    break;
                }
                c = c.getSuperclass();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIgnoreProperty(Class c, String propertyName) {
        Map map = ignoreProperties;
        synchronized (map) {
            HashSet<Class> propertyOwners = (HashSet<Class>)ignoreProperties.get(propertyName);
            if (propertyOwners == null) {
                propertyOwners = new HashSet<Class>();
                ignoreProperties.put(propertyName, propertyOwners);
            }
            propertyOwners.add(c);
        }
    }

    public static boolean isPublicField(int modifiers) {
        return Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers);
    }

    public static boolean isPublicAccessor(int modifiers) {
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    public Object clone() {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map map = ignoreProperties;
        synchronized (map) {
            ignoreProperties.clear();
        }
        map = propertyNamesCache;
        synchronized (map) {
            propertyNamesCache.clear();
        }
        map = beanPropertyCache;
        synchronized (map) {
            beanPropertyCache.clear();
        }
        map = propertyDescriptorCache;
        synchronized (map) {
            propertyDescriptorCache.clear();
        }
    }

    static {
        BeanProxy.addIgnoreProperty(AbstractMap.class, "empty");
        BeanProxy.addIgnoreProperty(AbstractCollection.class, "empty");
        BeanProxy.addIgnoreProperty(ASObject.class, "type");
        BeanProxy.addIgnoreProperty(Throwable.class, "stackTrace");
        BeanProxy.addIgnoreProperty(File.class, "parentFile");
        BeanProxy.addIgnoreProperty(File.class, "canonicalFile");
        BeanProxy.addIgnoreProperty(File.class, "absoluteFile");
    }

    protected static class PropertyDescriptorCacheEntry {
        PropertyDescriptor[] propertyDescriptors;
        Map propertiesByName;

        protected PropertyDescriptorCacheEntry() {
        }
    }

    protected static class BeanProperty {
        private String name;
        private Class type;
        private Method readMethod;
        private Method writeMethod;
        private Field field;

        protected BeanProperty(String name, Class type, Method read, Method write, Field field) {
            this.name = name;
            this.type = type;
            this.writeMethod = write;
            this.readMethod = read;
            this.field = field;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }

        public boolean isWrite() {
            return this.writeMethod != null || this.field != null;
        }

        public boolean isRead() {
            return this.readMethod != null || this.field != null;
        }

        public Class getReadDeclaringClass() {
            if (this.readMethod != null) {
                return this.readMethod.getDeclaringClass();
            }
            if (this.field != null) {
                return this.field.getDeclaringClass();
            }
            return null;
        }

        public Class getReadType() {
            if (this.readMethod != null) {
                return this.readMethod.getReturnType();
            }
            if (this.field != null) {
                return this.field.getType();
            }
            return null;
        }

        public String getWriteName() {
            if (this.writeMethod != null) {
                return "method " + this.writeMethod.getName();
            }
            if (this.field != null) {
                return "field " + this.field.getName();
            }
            return null;
        }

        public void set(Object bean, Object value) throws IllegalAccessException, InvocationTargetException {
            if (this.writeMethod != null) {
                this.writeMethod.invoke(bean, value);
            } else if (this.field != null) {
                this.field.set(bean, value);
            } else {
                throw new MessageException("Setter not found for property " + this.name);
            }
        }

        public Object get(Object bean) throws IllegalAccessException, InvocationTargetException {
            Object obj = null;
            if (this.readMethod != null) {
                obj = this.readMethod.invoke(bean, (Object[])null);
            } else if (this.field != null) {
                obj = this.field.get(bean);
            }
            return obj;
        }
    }
}

