/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.util.Assert;

class DefaultBootstrapContext
implements BootstrapContext {
    private final Class<?> testClass;
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;

    DefaultBootstrapContext(Class<?> testClass, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        Assert.notNull(testClass, (String)"Test class must not be null");
        Assert.notNull((Object)cacheAwareContextLoaderDelegate, (String)"CacheAwareContextLoaderDelegate must not be null");
        this.testClass = testClass;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public CacheAwareContextLoaderDelegate getCacheAwareContextLoaderDelegate() {
        return this.cacheAwareContextLoaderDelegate;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", (Object)this.testClass.getName()).append("cacheAwareContextLoaderDelegate", (Object)this.cacheAwareContextLoaderDelegate.getClass().getName()).toString();
    }
}

