/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.support;

import com.googlecode.ehcache.annotations.support.TaskSchedulerAdapter;
import com.googlecode.ehcache.annotations.support.TimerTaskSchedulerAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class TaskSchedulerAdapterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSchedulerAdapterFactory.class);
    private static final Class<?> TASK_SCHEDULER_CLASS;
    private static final Class<?> SPRING3_TASK_SCHEDULER_ADAPTOR_CLASS;
    private static final Constructor<?> SPRING3_TASK_SCHEDULER_ADAPTOR_CONSTRUCTOR;
    private static final boolean SPRING3;

    public static TaskSchedulerAdapter createTaskSchedulerAdapter(Object scheduler) {
        Assert.notNull((Object)scheduler);
        if (scheduler instanceof TaskSchedulerAdapter) {
            return (TaskSchedulerAdapter)scheduler;
        }
        if (SPRING3 && TASK_SCHEDULER_CLASS.isAssignableFrom(scheduler.getClass())) {
            try {
                return (TaskSchedulerAdapter)SPRING3_TASK_SCHEDULER_ADAPTOR_CONSTRUCTOR.newInstance(scheduler);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create Spring3TaskSchedulerAdapter instance by reflection to wrap " + scheduler.getClass(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create Spring3TaskSchedulerAdapter instance by reflection to wrap " + scheduler.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Failed to create Spring3TaskSchedulerAdapter instance by reflection to wrap " + scheduler.getClass(), e);
            }
        }
        if (scheduler instanceof Timer) {
            return new TimerTaskSchedulerAdapter((Timer)scheduler);
        }
        throw new IllegalArgumentException("Provided scheduler object of type " + scheduler.getClass() + " is not supported. Please provide a TaskScheduler, Timer or TaskSchedulerAdapter");
    }

    private TaskSchedulerAdapterFactory() {
    }

    static {
        Class<?> taskSchedulerClass = null;
        Class<?> spring3TaskSchedulerAdaptorClass = null;
        Constructor<?> spring3TaskSchedulerAdpatorConstructor = null;
        try {
            taskSchedulerClass = Class.forName("org.springframework.scheduling.TaskScheduler");
            spring3TaskSchedulerAdaptorClass = Class.forName("com.googlecode.ehcache.annotations.support.Spring3TaskSchedulerAdapter");
            spring3TaskSchedulerAdpatorConstructor = spring3TaskSchedulerAdaptorClass.getConstructor(taskSchedulerClass);
            LOGGER.debug("Found Spring 3.0 TaskScheduler, will use Spring3TaskSchedulerAdapter if provided with a TaskScheduler");
        }
        catch (Exception e) {
            LOGGER.debug("Could not find Spring 3.0 TaskScheduler, will use TimerTaskSchedulerAdapter if provided with a Timer");
        }
        TASK_SCHEDULER_CLASS = taskSchedulerClass;
        SPRING3_TASK_SCHEDULER_ADAPTOR_CLASS = spring3TaskSchedulerAdaptorClass;
        SPRING3_TASK_SCHEDULER_ADAPTOR_CONSTRUCTOR = spring3TaskSchedulerAdpatorConstructor;
        SPRING3 = TASK_SCHEDULER_CLASS != null && SPRING3_TASK_SCHEDULER_ADAPTOR_CLASS != null && SPRING3_TASK_SCHEDULER_ADAPTOR_CONSTRUCTOR != null;
    }
}

