/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Stack;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.junit.Before;

public class TestJSONArray
extends TestCase {
    private JSONArray jsonarray;
    private String string;

    @Before
    public void setUp() {
        this.jsonarray = new JSONArray();
        this.string = "";
    }

    public static void testJsonArray_IntWithLeadingZeros() {
        try {
            String string = "[001122334455]";
            JSONArray jsonarray = new JSONArray(string);
            TestJSONArray.assertEquals((String)"[1122334455]", (String)jsonarray.toString());
        }
        catch (Exception e) {
            TestJSONArray.fail((String)e.toString());
        }
    }

    public static void testJsonArray_ScintificNotation() {
        try {
            String string = "[666e666]";
            JSONArray jsonarray = new JSONArray(string);
            TestJSONArray.assertEquals((String)"[\"666e666\"]", (String)jsonarray.toString());
        }
        catch (Exception e) {
            TestJSONArray.fail((String)e.toString());
        }
    }

    public static void testJsonArray_DoubleWithLeadingAndTrailingZeros() {
        try {
            String string = "[00.10]";
            JSONArray jsonarray = new JSONArray(string);
            TestJSONArray.assertEquals((String)"[0.1]", (String)jsonarray.toString());
        }
        catch (Exception e) {
            TestJSONArray.fail((String)e.toString());
        }
    }

    public void testConstructor_MissingValue() {
        try {
            this.jsonarray = new JSONArray("[\n\r\n\r}");
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"Missing value at 5 [character 0 line 4]", (String)jsone.getMessage());
        }
    }

    public void testConstructor_Nan() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(Double.NaN);
            this.jsonarray.toString();
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSON does not allow non-finite numbers.", (String)jsone.getMessage());
        }
    }

    public void testConstructor_NegativeInfinity() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(Double.NEGATIVE_INFINITY);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSON does not allow non-finite numbers.", (String)jsone.getMessage());
        }
    }

    public void testConstructor_PositiveInfinity() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(Double.POSITIVE_INFINITY);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSON does not allow non-finite numbers.", (String)jsone.getMessage());
        }
    }

    public void testPut_PositiveInfinity() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(Double.POSITIVE_INFINITY);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSON does not allow non-finite numbers.", (String)jsone.getMessage());
        }
    }

    public void testGetDouble_EmptyArray() {
        try {
            this.jsonarray.getDouble(0);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSONArray[0] not found.", (String)jsone.getMessage());
        }
    }

    public void testGet_NegativeIndex() {
        try {
            this.jsonarray.get(-1);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)jsone.getMessage());
        }
    }

    public void testPut_Nan() {
        try {
            this.jsonarray.put(Double.NaN);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSON does not allow non-finite numbers.", (String)jsone.getMessage());
        }
    }

    public void testConstructor_Object() {
        try {
            this.jsonarray = new JSONArray(new Object());
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"JSONArray initial value should be a string or collection or array.", (String)jsone.getMessage());
        }
    }

    public void testConstructor_BadJson() {
        try {
            this.string = "[)";
            this.jsonarray = new JSONArray(this.string);
            TestJSONArray.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONArray.assertEquals((String)"Expected a ',' or ']' at 3 [character 4 line 1]", (String)jsone.getMessage());
        }
    }

    public void testToString_Locations() {
        try {
            this.string = " [\"San Francisco\", \"New York\", \"Seoul\", \"London\", \"Seattle\", \"Shanghai\"]";
            this.jsonarray = new JSONArray(this.string);
            TestJSONArray.assertEquals((String)"[\"San Francisco\",\"New York\",\"Seoul\",\"London\",\"Seattle\",\"Shanghai\"]", (String)this.jsonarray.toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testConstructor_Collection() {
        Stack<String> stringCol = new Stack<String>();
        stringCol.add("string1");
        stringCol.add("string2");
        stringCol.add("string3");
        stringCol.add("string4");
        this.jsonarray = new JSONArray(stringCol);
        TestJSONArray.assertEquals((String)"[\"string1\",\"string2\",\"string3\",\"string4\"]", (String)this.jsonarray.toString());
    }

    public void testConstructor_NullCollection() {
        Collection stringCol = null;
        this.jsonarray = new JSONArray(stringCol);
        TestJSONArray.assertEquals((String)"[]", (String)this.jsonarray.toString());
    }

    public void testConstructor_StringArray() {
        try {
            this.jsonarray = new JSONArray(new String[]{"string1", "string2"});
            TestJSONArray.assertEquals((String)"[\"string1\",\"string2\"]", (String)this.jsonarray.toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testOpt() {
        try {
            this.jsonarray = new JSONArray(new String[]{"string1", "string2"});
            TestJSONArray.assertEquals((Object)"string1", (Object)this.jsonarray.opt(0));
            TestJSONArray.assertEquals((Object)"string2", (Object)this.jsonarray.opt(1));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testToString_Exception() {
        this.jsonarray = new JSONArray();
        class BadJsonString
        implements JSONString {
            BadJsonString() {
            }

            public String toJSONString() {
                String[] arString = new String[]{"abc"};
                return arString[1];
            }
        }
        this.jsonarray.put(new BadJsonString());
        TestJSONArray.assertEquals(null, (String)this.jsonarray.toString());
    }

    public void testToString_Indents() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put(new JSONObject().put("abc", "123"));
            this.jsonarray.put("abc");
            this.jsonarray.put(new JSONArray().put(new JSONArray()).put(new JSONArray().put("123").put("abc")));
            TestJSONArray.assertEquals((String)"[\n    \"123\",\n    {\"abc\": \"123\"},\n    \"abc\",\n    [\n        [],\n        [\n            \"123\",\n            \"abc\"\n        ]\n    ]\n]", (String)this.jsonarray.toString(4));
            TestJSONArray.assertEquals((String)"[\"123\"]", (String)new JSONArray().put("123").toString(4));
            TestJSONArray.assertEquals((String)"[]", (String)new JSONArray().toString(4));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGet_InvalidIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.get(1);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[1] not found.", (String)e.getMessage());
        }
    }

    public void testGet_ValidIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            TestJSONArray.assertEquals((Object)"123", (Object)this.jsonarray.get(0));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetBoolean() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("true");
            this.jsonarray.put("false");
            this.jsonarray.put(true);
            this.jsonarray.put(false);
            this.jsonarray.put("TRUE");
            this.jsonarray.put("FALSE");
            TestJSONArray.assertTrue((boolean)this.jsonarray.getBoolean(0));
            TestJSONArray.assertFalse((boolean)this.jsonarray.getBoolean(1));
            TestJSONArray.assertTrue((boolean)this.jsonarray.getBoolean(2));
            TestJSONArray.assertFalse((boolean)this.jsonarray.getBoolean(3));
            TestJSONArray.assertTrue((boolean)this.jsonarray.getBoolean(4));
            TestJSONArray.assertFalse((boolean)this.jsonarray.getBoolean(5));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetBoolean_NonBoolean() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.getBoolean(0);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] is not a boolean.", (String)e.getMessage());
        }
    }

    public void testOptBoolean() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("true");
        this.jsonarray.put("false");
        this.jsonarray.put(true);
        this.jsonarray.put(false);
        this.jsonarray.put("TRUE");
        this.jsonarray.put("FALSE");
        this.jsonarray.put("grass");
        TestJSONArray.assertTrue((boolean)this.jsonarray.optBoolean(0));
        TestJSONArray.assertFalse((boolean)this.jsonarray.optBoolean(1));
        TestJSONArray.assertTrue((boolean)this.jsonarray.optBoolean(2));
        TestJSONArray.assertFalse((boolean)this.jsonarray.optBoolean(3));
        TestJSONArray.assertTrue((boolean)this.jsonarray.optBoolean(4));
        TestJSONArray.assertFalse((boolean)this.jsonarray.optBoolean(5));
        TestJSONArray.assertFalse((boolean)this.jsonarray.optBoolean(6));
    }

    public void testGetInt() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put(45);
            this.jsonarray.put(-98);
            TestJSONArray.assertEquals((int)123, (int)this.jsonarray.getInt(0));
            TestJSONArray.assertEquals((int)-12, (int)this.jsonarray.getInt(1));
            TestJSONArray.assertEquals((int)45, (int)this.jsonarray.getInt(2));
            TestJSONArray.assertEquals((int)-98, (int)this.jsonarray.getInt(3));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetInt_NonInteger() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("abc");
            this.jsonarray.getInt(0);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] is not a number.", (String)e.getMessage());
        }
    }

    public void testOptInt() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("123");
        this.jsonarray.put("-12");
        this.jsonarray.put(45);
        this.jsonarray.put(-98);
        this.jsonarray.put("abc");
        TestJSONArray.assertEquals((int)123, (int)this.jsonarray.optInt(0));
        TestJSONArray.assertEquals((int)-12, (int)this.jsonarray.optInt(1));
        TestJSONArray.assertEquals((int)45, (int)this.jsonarray.optInt(2));
        TestJSONArray.assertEquals((int)-98, (int)this.jsonarray.optInt(3));
        TestJSONArray.assertEquals((int)0, (int)this.jsonarray.optInt(4));
    }

    public void testGetDouble() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put(45);
            this.jsonarray.put(-98);
            this.jsonarray.put("123.5");
            this.jsonarray.put("-12.87");
            this.jsonarray.put(45.22);
            this.jsonarray.put(-98.18);
            TestJSONArray.assertEquals((Object)123.0, (Object)this.jsonarray.getDouble(0));
            TestJSONArray.assertEquals((Object)-12.0, (Object)this.jsonarray.getDouble(1));
            TestJSONArray.assertEquals((Object)45.0, (Object)this.jsonarray.getDouble(2));
            TestJSONArray.assertEquals((Object)-98.0, (Object)this.jsonarray.getDouble(3));
            TestJSONArray.assertEquals((Object)123.5, (Object)this.jsonarray.getDouble(4));
            TestJSONArray.assertEquals((Object)-12.87, (Object)this.jsonarray.getDouble(5));
            TestJSONArray.assertEquals((Object)45.22, (Object)this.jsonarray.getDouble(6));
            TestJSONArray.assertEquals((Object)-98.18, (Object)this.jsonarray.getDouble(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetDouble_NonDouble() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("abc");
            this.jsonarray.getDouble(0);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] is not a number.", (String)e.getMessage());
        }
    }

    public void testOptDouble() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("123");
        this.jsonarray.put("-12");
        this.jsonarray.put(45);
        this.jsonarray.put(-98);
        this.jsonarray.put("123.5");
        this.jsonarray.put("-12.87");
        try {
            this.jsonarray.put(45.22);
            this.jsonarray.put(-98.18);
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
        TestJSONArray.assertEquals((Object)123.0, (Object)this.jsonarray.optDouble(0));
        TestJSONArray.assertEquals((Object)-12.0, (Object)this.jsonarray.optDouble(1));
        TestJSONArray.assertEquals((Object)45.0, (Object)this.jsonarray.optDouble(2));
        TestJSONArray.assertEquals((Object)-98.0, (Object)this.jsonarray.optDouble(3));
        TestJSONArray.assertEquals((Object)123.5, (Object)this.jsonarray.optDouble(4));
        TestJSONArray.assertEquals((Object)-12.87, (Object)this.jsonarray.optDouble(5));
        TestJSONArray.assertEquals((Object)45.22, (Object)this.jsonarray.optDouble(6));
        TestJSONArray.assertEquals((Object)-98.18, (Object)this.jsonarray.optDouble(7));
        TestJSONArray.assertEquals((Object)Double.NaN, (Object)this.jsonarray.optDouble(8));
    }

    public void testGetLong() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put(45L);
            this.jsonarray.put(-98L);
            TestJSONArray.assertEquals((long)123L, (long)this.jsonarray.getLong(0));
            TestJSONArray.assertEquals((long)-12L, (long)this.jsonarray.getLong(1));
            TestJSONArray.assertEquals((long)45L, (long)this.jsonarray.getLong(2));
            TestJSONArray.assertEquals((long)-98L, (long)this.jsonarray.getLong(3));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetLong_NonLong() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("abc");
            this.jsonarray.getLong(0);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] is not a number.", (String)e.getMessage());
        }
    }

    public void testOptLong() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("123");
        this.jsonarray.put("-12");
        this.jsonarray.put(45L);
        this.jsonarray.put(-98L);
        TestJSONArray.assertEquals((long)123L, (long)this.jsonarray.optLong(0));
        TestJSONArray.assertEquals((long)-12L, (long)this.jsonarray.optLong(1));
        TestJSONArray.assertEquals((long)45L, (long)this.jsonarray.optLong(2));
        TestJSONArray.assertEquals((long)-98L, (long)this.jsonarray.optLong(3));
        TestJSONArray.assertEquals((long)0L, (long)this.jsonarray.optLong(8));
    }

    public void testGetString() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put("abc");
            this.jsonarray.put("123");
            TestJSONArray.assertEquals((String)"123", (String)this.jsonarray.getString(0));
            TestJSONArray.assertEquals((String)"-12", (String)this.jsonarray.getString(1));
            TestJSONArray.assertEquals((String)"abc", (String)this.jsonarray.getString(2));
            TestJSONArray.assertEquals((String)"123", (String)this.jsonarray.getString(3));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetString_NonString() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(123);
            this.jsonarray.getString(0);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] not a string.", (String)e.getMessage());
        }
    }

    public void testOptString() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("123");
        this.jsonarray.put("-12");
        this.jsonarray.put("abc");
        this.jsonarray.put("123");
        TestJSONArray.assertEquals((String)"123", (String)this.jsonarray.optString(0));
        TestJSONArray.assertEquals((String)"-12", (String)this.jsonarray.optString(1));
        TestJSONArray.assertEquals((String)"abc", (String)this.jsonarray.optString(2));
        TestJSONArray.assertEquals((String)"123", (String)this.jsonarray.optString(3));
        TestJSONArray.assertEquals((String)"", (String)this.jsonarray.optString(4));
    }

    public void testOptJSONObject() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(new JSONObject().put("abc", "123"));
            TestJSONArray.assertEquals((String)"{\"abc\":\"123\"}", (String)this.jsonarray.optJSONObject(0).toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testOptJSONObject_NonJsonObject() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("123");
        TestJSONArray.assertEquals(null, (Object)this.jsonarray.optJSONObject(0));
    }

    public void testOptJSONArray() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put(new JSONArray().put("abc"));
        TestJSONArray.assertEquals((String)"[\"abc\"]", (String)this.jsonarray.optJSONArray(0).toString());
    }

    public void testOptJSONArray_NonJsonArray() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put("123");
        TestJSONArray.assertEquals(null, (Object)this.jsonarray.optJSONArray(0));
    }

    public void testIsNull() {
        this.jsonarray = new JSONArray();
        this.jsonarray.put(JSONObject.NULL);
        this.jsonarray.put("null");
        TestJSONArray.assertTrue((boolean)this.jsonarray.isNull(0));
        TestJSONArray.assertFalse((boolean)this.jsonarray.isNull(1));
    }

    public void testWriter() {
        try {
            StringWriter sw = new StringWriter();
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put(45);
            this.jsonarray.put(-98);
            this.jsonarray.put(new JSONArray().put("abc"));
            this.jsonarray.put("-12");
            this.jsonarray.put("abc");
            this.jsonarray.put("123");
            this.jsonarray.put("123");
            this.jsonarray.put(new JSONObject().put("abc", "123"));
            this.jsonarray.put("abc");
            this.jsonarray.put("123");
            this.jsonarray.write(sw);
            TestJSONArray.assertEquals((String)"[\"123\",\"-12\",45,-98,[\"abc\"],\"-12\",\"abc\",\"123\",\"123\",{\"abc\":\"123\"},\"abc\",\"123\"]", (String)sw.toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testWriter_BadWriter() {
        try {
            class BadWriter
            extends Writer {
                BadWriter() {
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    throw new IOException("Test Message From Bad Writer");
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            }
            BadWriter sw = new BadWriter();
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put(45);
            this.jsonarray.put(-98);
            this.jsonarray.put(new JSONArray().put("abc"));
            this.jsonarray.put("-12");
            this.jsonarray.put("abc");
            this.jsonarray.put("123");
            this.jsonarray.put("123");
            this.jsonarray.put(new JSONObject().put("abc", "123"));
            this.jsonarray.put("abc");
            this.jsonarray.put("123");
            this.jsonarray.write(sw);
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"Test Message From Bad Writer", (String)e.getMessage());
        }
    }

    public void testPut_ObjectAndSpecificIndex() {
        try {
            testObject a = new testObject();
            testObject b = new testObject();
            testObject c = new testObject();
            testObject d = new testObject();
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, a);
            this.jsonarray.put(1, b);
            TestJSONArray.assertEquals((Object)a, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)b, (Object)this.jsonarray.get(1));
            this.jsonarray.put(0, c);
            TestJSONArray.assertEquals((Object)c, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)b, (Object)this.jsonarray.get(1));
            this.jsonarray.put(8, d);
            TestJSONArray.assertEquals((Object)d, (Object)this.jsonarray.get(8));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_ObjectAndNegativeIndex() {
        try {
            testObject a = new testObject();
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, a);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testToJSONObject() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.put("-12");
            this.jsonarray.put(45);
            this.jsonarray.put(-98);
            this.jsonarray.put(new JSONArray().put("abc"));
            this.jsonarray.put(new JSONObject().put("abc", "123"));
            JSONArray names = new JSONArray(new String[]{"bdd", "fdsa", "fds", "ewre", "rer", "gfs"});
            TestJSONArray.assertEquals((String)"{\"gfs\":{\"abc\":\"123\"},\"fdsa\":\"-12\",\"bdd\":\"123\",\"ewre\":-98,\"rer\":[\"abc\"],\"fds\":45}", (String)this.jsonarray.toJSONObject(names).toString());
            TestJSONArray.assertEquals(null, (Object)this.jsonarray.toJSONObject(new JSONArray()));
            TestJSONArray.assertEquals(null, (Object)this.jsonarray.toJSONObject(null));
            TestJSONArray.assertEquals(null, (Object)new JSONArray().toJSONObject(names));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetJSONObject() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(new JSONObject().put("abc", "123"));
            TestJSONArray.assertEquals((String)"{\"abc\":\"123\"}", (String)this.jsonarray.getJSONObject(0).toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetJSONObject_NonJsonObject() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.getJSONObject(0);
            TestJSONArray.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] is not a JSONObject.", (String)e.getMessage());
        }
    }

    public void testGetJSONArray() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(new JSONArray().put("abc"));
            TestJSONArray.assertEquals((String)"[\"abc\"]", (String)this.jsonarray.getJSONArray(0).toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testGetJSONArray_NonJsonArray() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put("123");
            this.jsonarray.getJSONArray(0);
            TestJSONArray.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[0] is not a JSONArray.", (String)e.getMessage());
        }
    }

    public void testPut_Map() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("abc", "123");
        this.jsonarray = new JSONArray();
        this.jsonarray.put(map);
        TestJSONArray.assertEquals((String)"[{\"abc\":\"123\"}]", (String)this.jsonarray.toString());
    }

    public void testConstructor_BadJsonArray() {
        try {
            this.jsonarray = new JSONArray("abc");
            TestJSONArray.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"A JSONArray text must start with '[' at 1 [character 2 line 1]", (String)e.getMessage());
        }
    }

    public void testConstructor() {
        try {
            this.jsonarray = new JSONArray("[]");
            TestJSONArray.assertEquals((String)"[]", (String)this.jsonarray.toString());
            this.jsonarray = new JSONArray("[\"abc\"]");
            TestJSONArray.assertEquals((String)"[\"abc\"]", (String)this.jsonarray.toString());
            this.jsonarray = new JSONArray("[\"abc\",\"123\"]");
            TestJSONArray.assertEquals((String)"[\"abc\",\"123\"]", (String)this.jsonarray.toString());
            this.jsonarray = new JSONArray("[123,{}]");
            TestJSONArray.assertEquals((String)"[123,{}]", (String)this.jsonarray.toString());
            this.jsonarray = new JSONArray("[123,,{}]");
            TestJSONArray.assertEquals((String)"[123,null,{}]", (String)this.jsonarray.toString());
            this.jsonarray = new JSONArray("[123,,{},]");
            TestJSONArray.assertEquals((String)"[123,null,{}]", (String)this.jsonarray.toString());
            this.jsonarray = new JSONArray("[123,,{};]");
            TestJSONArray.assertEquals((String)"[123,null,{}]", (String)this.jsonarray.toString());
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_Collection() {
        Stack<String> stringCol = new Stack<String>();
        stringCol.add("string1");
        stringCol.add("string2");
        stringCol.add("string3");
        stringCol.add("string4");
        this.jsonarray = new JSONArray();
        this.jsonarray.put(stringCol);
        TestJSONArray.assertEquals((String)"[[\"string1\",\"string2\",\"string3\",\"string4\"]]", (String)this.jsonarray.toString());
    }

    public void testPut_BooleanAndSpecificIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, true);
            this.jsonarray.put(1, true);
            TestJSONArray.assertEquals((Object)true, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)true, (Object)this.jsonarray.get(1));
            this.jsonarray.put(0, false);
            TestJSONArray.assertEquals((Object)false, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)true, (Object)this.jsonarray.get(1));
            this.jsonarray.put(8, false);
            TestJSONArray.assertEquals((Object)false, (Object)this.jsonarray.get(8));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_BooleanAndNegativeIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, true);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testPut_CollectionAndSpecificIndex() {
        try {
            Stack<String> a = new Stack<String>();
            a.add("string1");
            a.add("string4");
            Stack<String> b = new Stack<String>();
            b.add("string2");
            b.add("string3");
            Stack<String> c = new Stack<String>();
            c.add("string3");
            c.add("string4");
            Stack<String> d = new Stack<String>();
            d.add("string1");
            d.add("string2");
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, a);
            this.jsonarray.put(1, b);
            TestJSONArray.assertEquals((String)new JSONArray(a).toString(), (String)this.jsonarray.get(0).toString());
            TestJSONArray.assertEquals((String)new JSONArray(b).toString(), (String)this.jsonarray.get(1).toString());
            this.jsonarray.put(0, c);
            TestJSONArray.assertEquals((String)new JSONArray(c).toString(), (String)this.jsonarray.get(0).toString());
            TestJSONArray.assertEquals((String)new JSONArray(b).toString(), (String)this.jsonarray.get(1).toString());
            this.jsonarray.put(8, d);
            TestJSONArray.assertEquals((String)new JSONArray(d).toString(), (String)this.jsonarray.get(8).toString());
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_CollectionAndNegativeIndex() {
        try {
            Stack<String> a = new Stack<String>();
            a.add("string1");
            a.add("string4");
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, a);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testPut_DoubleAndSpecificIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, 10.0);
            this.jsonarray.put(1, 30.2);
            TestJSONArray.assertEquals((Object)10.0, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)30.2, (Object)this.jsonarray.get(1));
            this.jsonarray.put(0, 52.64);
            TestJSONArray.assertEquals((Object)52.64, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)30.2, (Object)this.jsonarray.get(1));
            this.jsonarray.put(8, 14.23);
            TestJSONArray.assertEquals((Object)14.23, (Object)this.jsonarray.get(8));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_DoubleAndNegativeIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, 30.65);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testPut_IntAndSpecificIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, 54);
            this.jsonarray.put(1, 82);
            TestJSONArray.assertEquals((Object)54, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)82, (Object)this.jsonarray.get(1));
            this.jsonarray.put(0, 36);
            TestJSONArray.assertEquals((Object)36, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)82, (Object)this.jsonarray.get(1));
            this.jsonarray.put(8, 67);
            TestJSONArray.assertEquals((Object)67, (Object)this.jsonarray.get(8));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_IntAndNegativeIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, 3);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testPut_LongAndSpecificIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, 54L);
            this.jsonarray.put(1, 456789123L);
            TestJSONArray.assertEquals((Object)54L, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)456789123L, (Object)this.jsonarray.get(1));
            this.jsonarray.put(0, 72887L);
            TestJSONArray.assertEquals((Object)72887L, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)456789123L, (Object)this.jsonarray.get(1));
            this.jsonarray.put(8, 39397L);
            TestJSONArray.assertEquals((Object)39397L, (Object)this.jsonarray.get(8));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_LongAndNegativeIndex() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, 456486794L);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testPut_MapAndSpecificIndex() {
        try {
            HashMap<String, String> a = new HashMap<String, String>();
            a.put("abc", "123");
            HashMap<String, String> b = new HashMap<String, String>();
            b.put("abffc", "1253");
            HashMap<String, String> c = new HashMap<String, String>();
            c.put("addbc", "145623");
            HashMap<String, String> d = new HashMap<String, String>();
            d.put("abffdc", "122623");
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, a);
            this.jsonarray.put(1, b);
            TestJSONArray.assertEquals((String)new JSONObject(a).toString(), (String)this.jsonarray.get(0).toString());
            TestJSONArray.assertEquals((String)new JSONObject(b).toString(), (String)this.jsonarray.get(1).toString());
            this.jsonarray.put(0, c);
            TestJSONArray.assertEquals((String)new JSONObject(c).toString(), (String)this.jsonarray.get(0).toString());
            TestJSONArray.assertEquals((String)new JSONObject(b).toString(), (String)this.jsonarray.get(1).toString());
            this.jsonarray.put(8, d);
            TestJSONArray.assertEquals((String)new JSONObject(d).toString(), (String)this.jsonarray.get(8).toString());
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(2));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(3));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(4));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(5));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(6));
            TestJSONArray.assertEquals((Object)JSONObject.NULL, (Object)this.jsonarray.get(7));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public void testPut_MapAndNegativeIndex() {
        try {
            HashMap<String, String> a = new HashMap<String, String>();
            a.put("abc", "123");
            this.jsonarray = new JSONArray();
            this.jsonarray.put(-1, a);
            TestJSONArray.fail((String)"Should have thrown exception");
        }
        catch (JSONException e) {
            TestJSONArray.assertEquals((String)"JSONArray[-1] not found.", (String)e.getMessage());
        }
    }

    public void testRemove() {
        try {
            this.jsonarray = new JSONArray();
            this.jsonarray.put(0, 54);
            this.jsonarray.put(1, 456789123);
            this.jsonarray.put(2, 72887);
            this.jsonarray.remove(1);
            TestJSONArray.assertEquals((Object)54, (Object)this.jsonarray.get(0));
            TestJSONArray.assertEquals((Object)72887, (Object)this.jsonarray.get(1));
        }
        catch (JSONException e) {
            TestJSONArray.fail((String)e.getMessage());
        }
    }

    public class testObject {
    }
}

